/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.google.gson.JsonObject;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ConfigurableHoneycombRecipe
implements CraftingRecipe {
    public final ResourceLocation id;
    public final Integer count;

    public ConfigurableHoneycombRecipe(ResourceLocation id, Integer count) {
        this.id = id;
        this.count = count;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        List<ItemStack> stacks = this.getItemsInInventory(inv);
        CompoundTag type = null;
        if (stacks.size() == this.count.intValue()) {
            for (ItemStack itemstack : stacks) {
                if (!itemstack.m_41619_() && itemstack.m_41720_().equals(ModItems.CONFIGURABLE_HONEYCOMB.get()) && itemstack.m_41782_()) {
                    if (type == null) {
                        type = itemstack.m_41783_();
                    }
                    if (type == null || type.equals((Object)itemstack.m_41783_())) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv) {
        List<ItemStack> stacks = this.getItemsInInventory(inv);
        if (stacks.size() > 0) {
            ItemStack inStack = stacks.get(0);
            ItemStack outStack = new ItemStack((ItemLike)ModItems.CONFIGURABLE_COMB_BLOCK.get());
            outStack.m_41751_(inStack.m_41783_());
            return outStack;
        }
        return ItemStack.f_41583_;
    }

    private List<ItemStack> getItemsInInventory(CraftingContainer inv) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            stacks.add(itemstack);
        }
        return stacks;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.count;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)ModItems.CONFIGURABLE_COMB_BLOCK.get());
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < this.count; ++i) {
            nonnulllist.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get())}));
        }
        return nonnulllist;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.CONFIGURABLE_HONEYCOMB.get();
    }

    public static class Serializer<T extends ConfigurableHoneycombRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation id, JsonObject json) {
            Integer count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)4);
            return this.factory.create(id, count);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                return this.factory.create(id, buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading config honeycomb recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                buffer.writeInt(((ConfigurableHoneycombRecipe)recipe).count.intValue());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing config honeycomb recipe to packet. " + ((ConfigurableHoneycombRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends ConfigurableHoneycombRecipe> {
            public T create(ResourceLocation var1, Integer var2);
        }
    }
}

